# AI + Cursor 开发一个亲戚计算器

## 开发过程直播回放

点击观看：[直播教程回放](https://www.codefather.cn/live/1901529692141826049)

AI 的应用场景：增强传统应用 + 创新应用

本教程全程利用 Cursor + DeepSeek AI，不自己写任何一行代码，实现前端项目的开发和部署。

效果如图：

![img](https://pic.yupi.icu/yuyi/4LjFFoKdD7eStAe4.webp)

## 一、需求分析

亲戚计算器：可以任意输入亲戚关系、得到一个计算结果

![img](https://pic.yupi.icu/yuyi/SSZhiv8c2hlFgbq1.webp)

### 需求分析 - AI 的思考

可以让 AI 辅助需求分析，拓宽我们的想象力

**一、基础功能升级：**

- **语音输入/输出（❌ 不做）：** 解放双手，直接说出“我妈妈的姐姐的女儿是谁”，AI 自动识别关系并回答“你的表姐”。
- **方言支持 P1：** 识别不同地区对亲戚的称呼差异，例如“姥爷”和“外公”，“姑妈”和“姨妈”。
- **关系图谱可视化 P0：** 输入一个名字，自动生成家族关系图谱，清晰展示家族成员之间的关系。
- **亲戚关系百科 P2：** 点击任意亲戚关系，显示该关系的详细解释、常见称呼、风俗习惯等。

**二、趣味功能拓展（暂时不做）：**

- **亲戚关系推理游戏：** AI 给出一些线索，用户猜测目标人物与自己的关系，例如“她是我妈妈的妹妹的女儿，但不是我表姐，她是谁？”。
- **亲戚称呼挑战：** AI 随机生成复杂亲戚关系，用户需要在限定时间内说出正确称呼，挑战你的反应速度和亲戚知识储备。
- **亲戚关系预测（不错）：** 输入你和伴侣的生日，AI 预测你们未来孩子的亲戚关系图，例如“你的孩子将会有多少个表兄弟姐妹”。
- **亲戚关系社交：** 连接家族成员，分享家族故事、照片、视频，记录家族历史，增强家族凝聚力。

**三、AI 增强功能（暂时不做）：**

- **智能推荐称呼：** 根据用户输入的关系，AI 自动推荐最合适的称呼，避免称呼不当的尴尬。
- **亲戚关系分析：** AI 分析用户的家族关系，识别出关系紧密的亲戚，并提供维护关系的建议。
- **家族基因预测：** 结合家族成员的健康数据，AI 预测用户患某些疾病的风险，并提供预防建议。
- **家族文化传承：** AI 根据用户的家族历史和文化背景，推荐相关的书籍、电影、音乐等，帮助用户了解家族文化。

**四、其他创意功能（暂时不做）：**

- **亲戚关系主题表情包：** 根据不同的亲戚关系，生成一系列搞笑表情包，例如“被七大姑八大姨催婚的我”。
- **亲戚关系主题滤镜：** 开发一些与亲戚关系相关的 AR 滤镜，例如“变身成我的小姨”。
- **亲戚关系主题游戏：** 开发一些与亲戚关系相关的小游戏，例如“亲戚连连看”、“亲戚关系大冒险”等。

**目标用户：**

- 对亲戚关系感到困惑的年轻人
- 想要了解家族历史的用户
- 喜欢尝试新鲜事物的用户
- 想要增强家族凝聚力的用户

### 最终要做的需求

1. 首先是能够让用户在计算器上输入亲戚关系，最终给出答案
2. 输出关系图谱，更直观地让用户了解亲戚关系
3. 让 AI 给出亲戚的分析和计算过程

## 二、方案设计

打算全程使用 AI 实现，应该只需要前端就可以实现（暂时不用后端，降低开发复杂度）

### 技术选型

以 Cursor 为主，DeepSeek 作为辅助

### 原型图

参考已有产品，可以让 AI 根据原型图来开发前端

![img](https://pic.yupi.icu/yuyi/s88hP0jpmWk23LW8.png)

### Cursor 介绍

AI 驱动的代码编辑器

基本概念：

- AI Agent（智能体）：理解成人，拿到需求后，会自己利用工具来完成
- AI 大模型：AI 底层的计算支持

AI Agent 可以基于不同的 AI 大模型去实现

#### 使用技巧

刚开始生成网页时，一定要用高级推理，尽量用最新的大模型

## 三、实现

### 实现步骤

1）从 0 输入完整 Prompt，交给 AI 进行基础生成【亲戚计算器】

2）优化页面

3）优化功能逻辑

4）人工校验，对部分功能逻辑进行增强

5）基本逻辑完成后，开发更多功能【可视化图谱】

6）优化【可视化图谱】逻辑、优化展示，能够根据用户的选择实时更新

7）人工校验，修复错误

8）【让 AI 给出亲戚的分析和计算过程】

### 生成网页的 Prompt

#### 自己写的 Prompt

现在我要开发一个亲戚计算器【网站】，要求实现如下需求：

1. 能够让用户在计算器上输入亲戚关系，最终给出答案
2. 能够输出关系图谱，更直观地让用户了解亲戚关系
3. 给出答案的分析和计算过程（每一个步骤都要讲清楚）

要求：

1. 单页面应用
2. 根据我给出的界面原型图进行网站界面的开发

技术栈：HTML + CSS + JS

#### 利用 AI 优化 Prompt

![img](https://pic.yupi.icu/yuyi/PNUEwBHWembedWBx.webp)

```markdown
▼markdown

复制代码**项目目标：**  
开发一个单页面应用（SPA）的亲戚计算器网站，用户可以通过输入亲戚关系，获取准确的亲戚称呼，并可视化展示关系图谱。同时，网站需提供详细的计算过程分析，帮助用户理解每一步的逻辑。

---

**功能需求：**  
1. **亲戚关系计算功能：**  
   - 用户可以通过输入框或选择器输入亲戚关系（例如：“我妈妈的妹妹的女儿”）。  
   - 网站能够解析输入的关系，并输出正确的亲戚称呼（例如：“表妹”）。  

2. **关系图谱可视化：**  
   - 根据用户输入的关系，动态生成关系图谱，以图形化的方式展示家族成员之间的关系。  
   - 图谱需支持缩放、拖拽等交互功能，方便用户查看复杂关系。  

3. **计算过程分析：**  
   - 在给出最终答案的同时，显示详细的计算步骤（例如：  
     - 第一步：“妈妈的妹妹” → 姑姑  
     - 第二步：“姑姑的女儿” → 表妹）。  
   - 每一步需附带简短的解释，帮助用户理解逻辑。  

---

**界面需求：**  
1. **单页面应用（SPA）：**  
   - 所有功能集中在一个页面内，无需跳转。  
   - 页面布局简洁，分为输入区、结果展示区、关系图谱区和计算过程分析区。  

2. **界面原型：**  
   - 根据提供的界面原型图进行开发，确保布局、配色、字体等与原型一致。  
   - 支持响应式设计，适配不同设备（桌面、平板、手机）。  

---

**技术栈：**  
- **前端：** HTML + CSS + JavaScript  
- **可视化库：** 使用 D3.js 或类似库实现关系图谱的可视化。  
- **交互逻辑：** 使用原生 JavaScript 实现动态交互。  

---

**其他要求：**  
1. **代码结构清晰：**  
   - 使用模块化编程，将计算逻辑、图谱生成、UI 渲染等功能分离。  
   - 添加必要的注释，便于后续维护和扩展。  

2. **用户体验优化：**  
   - 提供输入示例或提示，帮助用户正确输入关系。  
   - 在用户输入错误时，给出友好的错误提示（例如：“无法识别的关系，请检查输入”）。  

3. **性能优化：**  
   - 确保图谱渲染和计算过程流畅，避免卡顿。  

---

**示例输入输出：**  
- 输入：“我妈妈的妹妹的女儿”  
- 输出：  
  - 称呼：“表妹”  
  - 关系图谱：（图形化展示从“我”到“表妹”的关系链）  
  - 计算过程：  
    1. “妈妈的妹妹” → 姑姑  
    2. “姑姑的女儿” → 表妹  

---

通过以上优化后的提示词，Cursor 可以更清晰地理解你的需求，生成更符合预期的代码和界面设计。如果需要进一步调整或补充，可以随时告诉我！
```

### 最终效果

![img](https://pic.yupi.icu/yuyi/DDNYZn9XgE51yAdE.webp)

## 四、扩展知识

目前纯前端的亲戚计算器通过枚举 + 递归实现，在亲戚关系较复杂的情况下，难以给出准确的答案？

解决方案：可以通过调用后端，后端接入 AI，让 AI 来给出亲戚的分析结果。

进一步优化：但是纯调后端又很费钱，针对能枚举的计算、直接调用前端；前端无法给出答案的情况，再调用后端。

## 五、项目部署

一般部署项目需要服务器，免费的途径有：Vercel、或者用 [Sealos](https://hzh.sealos.run/)（搭建很多集成环境的云服务器）+ DevBox（开发工具箱）

通过 DevBox 挑选模板创建项目，然后可以利用 Cursor 连接服务器进行远程开发，开发完成后发版，最后通过 Sealos 的应用管理进行上线部署。

![img](https://pic.yupi.icu/yuyi/lAEIdpSsHSeIXYUh.webp)

----

加入编程导航，获取 10+ 套原创企业级实战项目，可以直接写进简历：

https://yuyuanweb.feishu.cn/wiki/VC1qwmX9diCBK3kidyec74vFnde
